<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Skill extends Model 
{

    protected $table = 'skills';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function belongsToMany()
    {
        return $this->belongsToMany('App\Models\SkillParent', 'skill_id');
    }

    public function belongsToCategories()
    {
        return $this->belongsToMany('App\Models\SkillCategoriesRel', 'skill_uuid');
    }

}